import flask
from flask import request, jsonify

from validator import Yahoo

app = flask.Flask(__name__)
app.config["DEBUG"] = True

# Create some test data for our catalog in the form of a list of dictionaries.
books = [
    {'id': 0,
     'title': 'A Fire Upon the Deep',
     'author': 'Vernor Vinge',
     'first_sentence': 'The coldsleep itself was dreamless.',
     'year_published': '1992'},
    {'id': 1,
     'title': 'The Ones Who Walk Away From Omelas',
     'author': 'Ursula K. Le Guin',
     'first_sentence': 'With a clamor of bells that set the swallows soaring, the Festival of Summer came to the city Omelas, bright-towered by the sea.',
     'published': '1973'},
    {'id': 2,
     'title': 'Dhalgren',
     'author': 'Samuel R. Delany',
     'first_sentence': 'to wound the autumnal city.',
     'published': '1975'}
]


@app.route('/', methods=['GET'])
def home():
    return '''<h1>Yahoo Email Validator</h1>'''


@app.route('/validate', methods=['GET'])
def validate_one():
    if 'email' in request.args:
        email = request.args['email']
    else:
        return "Error: No email field provided. Please specify an email."

    results = []
    yahoo_validator = Yahoo()

    result_string = yahoo_validator.validate(email)
    match = {
        'status': result_string,
    }
    results.append(match)

    return jsonify(results)

app.run()
