import sys
import time
import urllib
import requests
import requests.auth
from queue import Queue
from threading import Thread
from datetime import datetime
import csv
import random
import math
from requests_ip_rotator import ApiGateway, EXTRA_REGIONS

class Yahoo(object):
    
    def __init__(self):
        ua = []
        ua.append('Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1)')
        ua.append('AppleWebKit/537.36 (KHTML, like Gecko)')
        ua.append('Chrome/63.0.3239.108 Safari/537.36')
        content_type = 'application/x-www-form-urlencoded; charset=UTF-8'
        url = 'https://login.yahoo.com/account/module/create'
        params = 'validateField=yid'
        self.url = '{0}?{1}'.format(url, params)
        self.headers = {'origin': 'https://login.yahoo.com',
                        'accept-encoding': 'gzip, deflate, br',
                        'accept-language': 'en-US,en;q=0.9',
                        'user-agent': ' '.join(ua),
                        'content-type': content_type,
                        'accept': '*/*',
                        'referer': self.url,
                        'authority': 'login.yahoo.com',
                        'x-requested-with': 'XMLHttpRequest'}

    def _valid_response_(self, response):
        if response and response.status_code:
            if response.status_code in range(200, 299):
                return True
        return False

    def _extract_crumb(self, cookies):
        acrumb = None
        for cookie in cookies:
            if cookie.name == 'AS':
                dataset = cookie.value.split('&')
                for data in dataset:
                    if data.startswith('s='):
                        acrumb = data[len('s='):]
        return acrumb

    def _browser_data(self, acrumb, mailbox):
        ftime_start = int(time.time())
        ftime_end = ftime_start + 10
        hash1 = '9b67333a6b5bebdd28000b90e96b4492'
        hash2 = 'ef2c0b3b2fae9bb10b1de1479dd2800d'
        browser_fp_data = {"language": "en-US",
                           "color_depth": 24,
                           "resolution": {"w": 1440,
                                          "h": 900},
                           "available_resolution": {"w": 1440,
                                                    "h": 846},
                           "timezone_offset": 360,
                           "session_storage": 1,
                           "local_storage": 1,
                           "indexed_db": 1,
                           "open_database": 1,
                           "cpu_class": "unknown",
                           "navigator_platform": "MacIntel",
                           "do_not_track": "unknown",
                           "canvas": "canvas winding:yes~canvas",
                           "webgl": 1,
                           "adblock": 0,
                           "has_lied_languages": 0,
                           "has_lied_resolution": 0,
                           "has_lied_os": 0,
                           "has_lied_browser": 0,
                           "touch_support": {"points": 0,
                                             "event": 0,
                                             "start": 0},
                           "plugins": {"count": 4,
                                       "hash": hash1},
                           "fonts": {"count": 28,
                                     "hash": hash2},
                           "ts": {"serve": ftime_start,
                                  "render": ftime_end}}
        dict_args = {'specId': 'yidReg',
                     'cacheStored': 'true',
                     'crumb': 'UWnNVlKkXw4',
                     'acrumb': acrumb,
                     'sessionIndex': '',
                     'done': 'https%3A%2F%2Fwww.yahoo.com',
                     'googleIdToken': '',
                     'authCode': '',
                     'tos0': 'yahoo_freereg%7Cus%7Cen-US',
                     'tos1': 'yahoo_comms_atos%7Cus%7Cen-US',
                     'firstName': '',
                     'lastName': '',
                     'yid': mailbox,
                     'password': '',
                     'shortCountryCode': 'US',
                     'phone': '',
                     'mm': '',
                     'dd': '',
                     'yyyy': '',
                     'freeformGender': ''}

        return browser_fp_data, dict_args

    def _reshape_cookie(self, cookies):
        string = []
        for cookie in cookies:
            string.append('{0}={1}'.format(cookie.name, cookie.value))
        return ';'.join(string)

    def _digest_response(self, response):
        output = None
        if 'errors' in response:
            for error in response['errors']:
                if error['name'] == 'yid':
                    output = error['error']
        if output == 'IDENTIFIER_EXISTS':
            return ': email_enabled'
        return ': email_disabled'

    def _clean_mailbox(self, mailbox):
        if '@' in mailbox:
            return str(mailbox[:mailbox.find("@")])
        return str(mailbox)

    def get_tor_session(self):
        session = requests.session()
        httpcred = 'socks5://127.0.0.1:9050'
        session.proxies = {'http':  httpcred,
                        'https': httpcred}
        return session
    
    def get_proxy(self):
        proxies = [
            '185.193.74.32:3199',
            '45.57.231.46:3199',
            '181.177.76.60:3199',
            '168.81.231.114:3199',
            '216.10.4.203:3199',
            '168.81.246.31:3199',
            '104.249.7.165:3199',
            '141.98.154.237:3199',
            '91.205.105.18:3199',
            '181.177.79.24:3199',
            '168.81.215.249:3199',
            '23.254.29.160:3199',
            '185.195.214.185:3199',
            '186.179.0.2:3199',
            '168.80.149.112:3199',
            '181.177.73.184:3199',
            '194.61.31.215:3199',
            '104.233.51.4:3199',
            '186.179.24.248:3199',
            '168.80.149.191:3199',
            '23.250.74.89:3199',
            '181.177.66.175:3199',
            '23.254.72.143:3199',
            '186.179.25.126:3199',
            '185.193.73.57:3199',
            '168.80.167.130:3199',
            '104.144.102.135:3199',
            '168.81.71.107:3199',
            '185.199.118.238:3199',
            '193.22.146.139:3199'
        ]
        return random.choice(proxies)

    def validate(self, mailbox):
        # mailbox = self._clean_mailbox(mailbox)
        returnMailboxTxt = mailbox
        mailboxAry = mailbox.split('@')
        mailboxTxt = mailboxAry[0]

        auth = "jamses-1e765:HiJZyfqB8C"

        proxies_str = self.get_proxy()
        proxies_str = "http://" + auth + "@" + proxies_str
        print(proxies_str)
        proxies = {
            "http": proxies_str,
            "https": proxies_str
        }

        r = requests.get(self.url, proxies=proxies)

        if not self._valid_response_(r):
            return {'Error': 'Initial request error'}
        acrumb = self._extract_crumb(r.cookies)
        self.headers['cookie'] = self._reshape_cookie(r.cookies)
        browser_fp_data, dict_args = self._browser_data(acrumb, mailboxTxt)
        payload = {'browser-fp-data': browser_fp_data}
        payload.update(dict_args)

        req = requests.post(self.url, headers=self.headers, cookies=r.cookies, proxies=proxies, data=payload)
        
        if not self._valid_response_(r):
            return {'Error': 'Validation call error'}        
        return '{0} {1}'.format(returnMailboxTxt, self._digest_response(req.json()))

class printValidationData(Thread):
    def __init__(self, queue):
        Thread.__init__(self)
        self.queue = queue

    def printresult(self, result):
        with open('output.txt', 'a') as file:
            file.write(result)

    def run(self):
        while True:
            result = self.queue.get()
            self.printresult(result)
            self.queue.task_done()

class Validator(Thread):

    def __init__(self, emailqueue, resultqueue):
        Thread.__init__(self)
        self.emailqueue = emailqueue
        self.resultqueue = resultqueue

    def run(self):
        while True:
            mailbox = self.emailqueue.get()
            try:
                result = yahoo.validate(mailbox)
                print(result)
                self.resultqueue.put(result)
            finally:
                self.emailqueue.task_done()

def read_csv():
    yid_array = []
    with open('ytest_500.csv') as csv_file:
        csv_reader = csv.reader(csv_file, delimiter=',')
        line_count = 0
        count = 0
        for row in csv_reader:
            yemail = row[0].lower()
            if "@yahoo" in yemail:
                line_count += 1
                yid_array.append(yemail)
            count += 1
            if count == 500:
                break
        print(f'{line_count} yahoo emails in file.')
    return yid_array

if __name__ == '__main__':

    startTime = datetime.now()
    yahoo = Yahoo()

    yid = read_csv()

    emailQueue = Queue()
    resultQueue = Queue()
    
    for x in range(8):
        worker = Validator(emailQueue, resultQueue)
        worker.daemon = True
        worker.start()
    
    for mailbox in yid:
        if len(sys.argv) == 2:
            mailbox = sys.argv[1]
        emailQueue.put((mailbox))
    
    printer = printValidationData(resultQueue)
    printer.setDaemon = True
    printer.start()

    emailQueue.join()
    resultQueue.join()

    print('Took time : %s', datetime.now() - startTime)
    print(" === END === ")